/**************************************************************************************
  Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
  $Id: netPROXY.h 3338 2018-02-07 15:19:21Z AndreasB $: *//**

  \file netPROXY.h
  netPROXY core (runtime) main header file.

  \note Include this file to all modules which use netPROXY. It is not recommended to
        include the netPROXY header files separately to prevent include order issues.

**************************************************************************************/
#ifndef __NETPROXY_H
#define __NETPROXY_H

#include <string.h>
#include <stdint.h>
#include <stdbool.h>

#include "Hil_Compiler.h"

#include "netPROXY_Results.h"
#include "npx_types.h"

#ifdef NPX_LOM_PROGRAMMING_INTERFACE

#include "npx_core_api.h"
#include "npx_interface_api.h"
#include "npx_dictionary_api.h"
#include "npx_object_api.h"
#include "npx_async_api.h"
#include "npx_sync_api.h"
#include "npx_package_api.h"
#include "npx_eventlog_api.h"
#include "npx_extensions_api.h"

#endif

#endif /* __NETPROXY_H */
